import java.util.Scanner;
import java.util.List;
import java.util.ArrayList;
public class Main {
    public static long vectorProduct(long[] array, long[] a, long[] b) {
        return (a[0] - array[0]) * (b[1] - array[1]) - (a[1] - array[1]) * (b[0] - array[0]);
    }
    public static List<long[]> convexEnvelope(List<long[]> points) {
        points.sort((a, b) -> a[0] != b[0] ? Long.compare(a[0], b[0]) : Long.compare(a[1], b[1]));
        List<long[]> lower = new ArrayList<>();
        List<long[]> upper = new ArrayList<>();
        for (long[] p : points) {
            while (lower.size() >= 2 && vectorProduct(lower.get(lower.size() - 2), lower.get(lower.size() - 1), p) <= 0) {
                lower.remove(lower.size() - 1);
            }
            lower.add(p);
        }
        for (int i = points.size() - 1; i >= 0; i--) {
            long[] p = points.get(i);
            while (upper.size() >= 2 && vectorProduct(upper.get(upper.size() - 2), upper.get(upper.size() - 1), p) <= 0) {
                upper.remove(upper.size() - 1);
            }
            upper.add(p);
        }
        List<long[]> result = new ArrayList<>();
        for (int i = 0; i < lower.size() - 1; i++) {
            result.add(lower.get(i));
        }
        for (int i = 0; i < upper.size() - 1; i++) {
            result.add(upper.get(i));
        }
        return result;
    }
    public static long surfacePolygon(List<long[]> polygon) {
        int n = polygon.size();
        long area = 0;
        for (int i = 0; i < n; i++) {
            long[] p1 = polygon.get(i);
            long[] p2 = polygon.get((i + 1) % n);
            area += p1[0] * p2[1] - p1[1] * p2[0];
        }
        return Math.abs(area) / 2;
    }
    public static long almostConvexEnvelope(List<long[]> points) {
        int n = points.size();
        long minArea = Long.MAX_VALUE;
        for (int i = 0; i < n; i++) {
            List<long[]> subset = new ArrayList<>();
            for (int j = 0; j < n; j++) {
                if (j != i) {
                    subset.add(points.get(j));
                }
            }
            List<long[]> envelopes = convexEnvelope(subset);
            long area = surfacePolygon(envelopes);
            minArea = Math.min(minArea, area);
        }
        return minArea;
    }
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int n = sc.nextInt();
        List<long[]> points = new ArrayList<>();
        for (long i = 0; i < n; i++) {
            long x = sc.nextLong();
            long y = sc.nextLong();
            points.add(new long[]{x, y});
        }
        long res = almostConvexEnvelope(points);
        System.out.println(res);
    }
}